# Information for rspec-rails developers

rspec-rails lives in a complicated ecosystem. We need to run it against
multiple versions of rails and multiple versions of Ruby as well. There are
several tools already available to manage running against multiple versions of
Ruby (e.g. rvm), and there are even some multi-rails tools (e.g. multi-rails)
but we haven't found one that does exactly what we need here, so we've rolled
our own.

## The short version

    gem install thor bundler
    thor version:use 3.1.3
    rake

## The long version

### thor version:use

The `thor version:use` task accepts any released version of rails, or either the
3-0-stable or master branches.

    thor version:use master
    thor version:use 3-0-stable
    thor version:use 3-1-stable
    thor version:use 3.1.3 # or any release >= 3.0.0

It then does a few things:

* generates a .rails-version file with the version listed. This is used
  internally by assorted rake tasks.
* installs the bundle
    * this includes binstubs, which are stored in ./bin

At any time, if you want to change rails versions, run `thor version:use` with
a new version number. To play it safe, you probably want to also run `rake
clobber` to delete all the code generated by the previous rails version.
