# Copyright (C) 2011-2012 - Curtis Hovey <sinzui.is at verizon.net>
# This software is licensed under the MIT license (see the file COPYING).

from gdpfind import FindPlugin
from gdp.find import Finder
from testing import GeditTestCase


class FindPluginTestCase(GeditTestCase):

    def test_init(self):
        window, view, document = self.make_gedit(
            'plugins/gdp/data/snark12.txt')
        plugin = FindPlugin()
        self.assertIs(None, plugin.controller)
        self.assertIs(None, plugin.window)

    def test_do_activate(self):
        # do_activate sets up the menus and gets the controller.
        window, view, document = self.make_gedit(
            'plugins/gdp/data/snark12.txt')
        plugin = FindPlugin()
        plugin.window = window
        plugin.do_activate()
        self.assertIsInstance(plugin.controller, Finder)
        action = plugin.action_group.get_action('FindFiles')
        self.assertEqual('Find in files...', action.get_property('label'))

    def test_do_update_state(self):
        # do_update_state() is implemented, but it does nothing.
        window, view, document = self.make_gedit(
            'plugins/gdp/data/snark12.txt')
        plugin = FindPlugin()
        plugin.window = window
        plugin.do_activate()
        self.assertIs(None, plugin.do_update_state())

    def test_do_deactivate(self):
        # do_deactivate removes the menus and the controller.
        window, view, document = self.make_gedit(
            'plugins/gdp/data/snark12.txt')
        plugin = FindPlugin()
        plugin.window = window
        plugin.do_activate()
        plugin.do_deactivate()
        self.assertIs(None, plugin.controller)
