/*
 * Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __NB_ATTACHMENT_LIST_H__
#define __NB_ATTACHMENT_LIST_H__

#include <glib.h>

#include "nb_attachment.h"

typedef GPtrArray AttachmentList;

/* create and free object */
AttachmentList	* nb_attachment_list_new (void);
void		nb_attachment_list_free (AttachmentList * self);

gboolean	nb_attachment_list_add (AttachmentList * self, Attachment * a);
gboolean	nb_attachment_list_remove (AttachmentList * self, Attachment * a);

gint		nb_attachment_list_get_nb (AttachmentList * self);

void		nb_attachment_list_check (AttachmentList * self);

#endif
